//: [Vorherige Seite](@previous)
import UIKit
import PlaygroundSupport
//: ## Animation mit UIViewPropertyAnimator
//: ## – Zwischenstop & Kursänderung
//:
//Demo-View erstellen, Button verschieben und Live-View
let container = demoView(frame: CGRect(x: 0, y: 0,
                                       width: 400, height: 600))
let frame = container.frame
container.demoButton.center = CGPoint(x:frame.midX,
                                      y: frame.midY)
PlaygroundPage.current.liveView = container
//: Da der PropertyAnimator, wie oben erwähnt, eine Objekt-Instanz ist, kann die App auch während der Laufzeit Einfluss auf die Animation nehmen. Um das zu demonstrieren, müssen wir das Instanziieren des Objekts aus animate-Methode heraus nehmen. Die Methode, die beim Antippen des Button ausgeführt wird, legt nun keine Instanz mehr an, sondern arbeitet vielmehr mit der vorhandenen:
public class actionHandler: NSObject {
    
    private var animator = UIViewPropertyAnimator(duration: 2.0, curve: .easeInOut) {
        container.demoButton.center.x = frame.maxX
            - container.demoButton.frame.size.width
    }
    //Die Animate-Methode prüft bei jedem Tap auf den Button, ob der Animator läuft oder nciht und reagiert entsprechend
    public func animate() {
        if animator.isRunning {
            animator.pauseAnimation()
        } else {
            animator.startAnimation()
        }
    }
}
//: Anschließend können Sie die Action wie gewohnt an den Button anhängen
let responder = actionHandler()
container.demoButton.addTarget(responder, action: #selector(actionHandler.animate), for: .touchDown)
//: [Nächste Seite](@next)
